/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.asistente.valores;

import ec.gob.sri.dimm.api.colecciones.ElementoNombre;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModeloValoresPeriodo
implements ModeloValores {
    private boolean inicializado = false;
    private final Map<String, ElementoNombre> anios = new LinkedHashMap<String, ElementoNombre>();
    private final Map<String, ElementoNombreValor<String>> meses = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombre> micros = new LinkedHashMap<String, ElementoNombre>();

    public void inicializar() {
        if (!this.inicializado) {
            this.cargarAnios();
            this.cargarMeses();
            this.cargarMicros();
            this.inicializado = true;
        }
    }

    private void cargarAnios() {
        int anioActual;
        this.anios.clear();
        int i = anioActual = GregorianCalendar.getInstance().get(1);
        while (i >= 2000) {
            String anio = String.valueOf(i);
            this.anios.put(anio, new ElementoNombre(anio));
            --i;
        }
    }

    private void cargarMeses() {
        this.meses.clear();
        this.meses.put("01", (ElementoNombreValor<String>)new ElementoNombreValor("Enero", (Object)"01"));
        this.meses.put("02", (ElementoNombreValor<String>)new ElementoNombreValor("Febrero", (Object)"02"));
        this.meses.put("03", (ElementoNombreValor<String>)new ElementoNombreValor("Marzo", (Object)"03"));
        this.meses.put("04", (ElementoNombreValor<String>)new ElementoNombreValor("Abril", (Object)"04"));
        this.meses.put("05", (ElementoNombreValor<String>)new ElementoNombreValor("Mayo", (Object)"05"));
        this.meses.put("06", (ElementoNombreValor<String>)new ElementoNombreValor("Junio", (Object)"06"));
        this.meses.put("07", (ElementoNombreValor<String>)new ElementoNombreValor("Julio", (Object)"07"));
        this.meses.put("08", (ElementoNombreValor<String>)new ElementoNombreValor("Agosto", (Object)"08"));
        this.meses.put("09", (ElementoNombreValor<String>)new ElementoNombreValor("Septiembre", (Object)"09"));
        this.meses.put("10", (ElementoNombreValor<String>)new ElementoNombreValor("Octubre", (Object)"10"));
        this.meses.put("11", (ElementoNombreValor<String>)new ElementoNombreValor("Noviembre", (Object)"11"));
        this.meses.put("12", (ElementoNombreValor<String>)new ElementoNombreValor("Diciembre", (Object)"12"));
    }

    private void cargarMicros() {
        this.micros.clear();
        this.micros.put("SI", new ElementoNombre("SI"));
        this.micros.put("NO", new ElementoNombre("NO"));
    }

    public List<ElementoNombre> getAnios() {
        return new ArrayList<ElementoNombre>(this.anios.values());
    }

    public List<ElementoNombreValor<String>> getMeses() {
        return new ArrayList<ElementoNombreValor<String>>(this.meses.values());
    }

    public List<ElementoNombre> getMicros() {
        return new ArrayList<ElementoNombre>(this.micros.values());
    }
}

